<?php
class CreditController {
    
    public static function getPackages() {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->query("SELECT * FROM credit_packages WHERE is_active = 1 ORDER BY sort_order ASC");
        $packages = $stmt->fetchAll();
        
        $result = array_map(function($p) {
            return [
                'id' => $p['id'],
                'name' => $p['name'],
                'description' => $p['description'],
                'credits' => $p['credits'],
                'price' => $p['price'],
                'pricePerCredit' => $p['price_per_credit'],
                'features' => json_decode($p['features'] ?? '[]', true),
                'isPopular' => (bool)$p['is_popular'],
                'buttonText' => $p['button_text'],
                'sortOrder' => $p['sort_order'],
                'isActive' => (bool)$p['is_active']
            ];
        }, $packages);
        
        echo json_encode($result);
    }
    
    public static function createPackage() {
        AuthController::requireAdmin();
        
        $data = json_decode(file_get_contents('php://input'), true);
        $db = Database::getInstance()->getConnection();
        
        $stmt = $db->prepare("
            INSERT INTO credit_packages (name, description, credits, price, price_per_credit, features, is_popular, button_text, sort_order, is_active, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $data['name'],
            $data['description'] ?? '',
            $data['credits'],
            $data['price'],
            $data['pricePerCredit'] ?? null,
            json_encode($data['features'] ?? []),
            $data['isPopular'] ? 1 : 0,
            $data['buttonText'] ?? 'Get Started',
            $data['sortOrder'] ?? 0,
            $data['isActive'] ?? 1,
            time()
        ]);
        
        echo json_encode(['id' => $db->lastInsertId()]);
    }
    
    public static function updatePackage($id) {
        AuthController::requireAdmin();
        
        $data = json_decode(file_get_contents('php://input'), true);
        $db = Database::getInstance()->getConnection();
        
        $stmt = $db->prepare("
            UPDATE credit_packages SET 
                name = ?, description = ?, credits = ?, price = ?, price_per_credit = ?,
                features = ?, is_popular = ?, button_text = ?, sort_order = ?, is_active = ?
            WHERE id = ?
        ");
        $stmt->execute([
            $data['name'],
            $data['description'] ?? '',
            $data['credits'],
            $data['price'],
            $data['pricePerCredit'] ?? null,
            json_encode($data['features'] ?? []),
            $data['isPopular'] ? 1 : 0,
            $data['buttonText'] ?? 'Get Started',
            $data['sortOrder'] ?? 0,
            $data['isActive'] ?? 1,
            $id
        ]);
        
        echo json_encode(['success' => true]);
    }
    
    public static function deletePackage($id) {
        AuthController::requireAdmin();
        
        $db = Database::getInstance()->getConnection();
        $stmt = $db->prepare("DELETE FROM credit_packages WHERE id = ?");
        $stmt->execute([$id]);
        
        echo json_encode(['success' => true]);
    }
}
