<?php
class SettingsController {
    
    public static function getAll() {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->query("SELECT key, value FROM site_settings");
        $rows = $stmt->fetchAll();
        
        $settings = [];
        foreach ($rows as $row) {
            $settings[$row['key']] = $row['value'];
        }
        
        // Return with defaults
        $defaults = [
            'siteName' => 'DataListCanada',
            'siteDescription' => 'Premium Canadian B2B Data Lists',
            'heroTitle' => 'Premium Canadian B2B Data Lists',
            'heroSubtitle' => 'Access high-quality business leads',
            'creditCostPerLead' => '1',
            'contactEmail' => 'contact@datalistcanada.com',
            'primaryColor' => '#2563eb'
        ];
        
        echo json_encode(array_merge($defaults, $settings));
    }
    
    public static function update() {
        AuthController::requireAdmin();
        
        $data = json_decode(file_get_contents('php://input'), true);
        $db = Database::getInstance()->getConnection();
        
        foreach ($data as $key => $value) {
            $stmt = $db->prepare("INSERT OR REPLACE INTO site_settings (key, value) VALUES (?, ?)");
            $stmt->execute([$key, $value]);
        }
        
        echo json_encode(['success' => true]);
    }
}
